/**
 * YouList Service Worker (Backup)
 * Nota: O SW principal está em pwa.js via Blob
 * Este arquivo é opcional, caso prefira usar arquivo externo
 */

const CACHE_NAME = "youlist-cache-v2";
const urlsToCache = [
  "./",
  "./index.html",
  "./manifest.json",
  "./assets/css/styles.css",
  "./assets/js/logger.js",
  "./assets/js/player.js",
  "./assets/js/app.js",
  "./assets/js/pwa.js",
  "./assets/img/favicon.png",
  "./assets/img/icon-192.png",
  "./assets/img/icon-512.png"
];

// Instalação
self.addEventListener("install", (event) => {
  console.log('[SW] Instalando...');
  self.skipWaiting();
  
  event.waitUntil(
    caches.open(CACHE_NAME)
      .then(cache => {
        console.log('[SW] Cache aberto');
        return cache.addAll(urlsToCache);
      })
      .catch(err => {
        console.error('[SW] Erro ao cachear:', err);
      })
  );
});

// Ativação
self.addEventListener("activate", (event) => {
  console.log('[SW] Ativando...');
  
  event.waitUntil(
    caches.keys().then(cacheNames => {
      return Promise.all(
        cacheNames.map(cacheName => {
          if (cacheName !== CACHE_NAME) {
            console.log('[SW] Removendo cache antigo:', cacheName);
            return caches.delete(cacheName);
          }
        })
      );
    })
  );
  
  self.clients.claim();
});

// Fetch Strategy: Network First, Cache Fallback
self.addEventListener("fetch", (event) => {
  event.respondWith(
    fetch(event.request)
      .then(response => {
        // Clone a resposta antes de cachear
        const responseClone = response.clone();
        
        caches.open(CACHE_NAME).then(cache => {
          cache.put(event.request, responseClone);
        });
        
        return response;
      })
      .catch(() => {
        // Se network falhar, tenta o cache
        return caches.match(event.request)
          .then(response => {
            if (response) {
              return response;
            }
            
            // Se não tiver no cache, retorna página offline
            if (event.request.destination === 'document') {
              return caches.match('./index.html');
            }
          });
      })
  );
});

// Background Sync (opcional)
self.addEventListener('sync', (event) => {
  console.log('[SW] Background Sync:', event.tag);
  
  if (event.tag === 'sync-playlist') {
    event.waitUntil(syncPlaylist());
  }
});

async function syncPlaylist() {
  try {
    // Sincronizar playlist aqui se necessário
    console.log('[SW] Playlist sincronizada');
  } catch (err) {
    console.error('[SW] Erro ao sincronizar:', err);
  }
}