// === EASTER EGG: Konami Code ===
// Sequência: ↑ ↑ ↓ ↓ ← → ← → B A

(function() {
  const konamiCode = [
    'ArrowUp', 'ArrowUp',
    'ArrowDown', 'ArrowDown',
    'ArrowLeft', 'ArrowRight',
    'ArrowLeft', 'ArrowRight',
    'b', 'a'
  ];
  
  let konamiIndex = 0;
  let isKonamiActive = false;

  document.addEventListener('keydown', (e) => {
    const key = e.key.toLowerCase();
    
    // Verifica se a tecla pressionada corresponde à sequência
    if (key === konamiCode[konamiIndex].toLowerCase()) {
      konamiIndex++;
      
      // Se completou a sequência
      if (konamiIndex === konamiCode.length) {
        activateKonamiMode();
        konamiIndex = 0;
      }
    } else {
      // Reseta se errou
      konamiIndex = 0;
    }
  });

  function activateKonamiMode() {
    if (isKonamiActive) {
      deactivateKonamiMode();
      return;
    }

    isKonamiActive = true;
    
    // Adiciona classe ao body
    document.body.classList.add('konami-mode');
    
    // Cria mensagem
    const message = document.createElement('div');
    message.id = 'konami-message';
    message.innerHTML = `
      🎮 KONAMI CODE ATIVADO! 🎮<br>
      <span style="font-size: 18px; margin-top: 10px; display: block;">
        YouList modo PARTY! 🎉<br>
        Pressione ESC para sair
      </span>
    `;
    document.body.appendChild(message);
    
    setTimeout(() => {
      message.classList.add('show');
    }, 100);
    
    // Remove mensagem após 3 segundos
    setTimeout(() => {
      message.classList.remove('show');
      setTimeout(() => message.remove(), 500);
    }, 3000);
    
    // Adiciona listener para ESC
    document.addEventListener('keydown', escapeListener);
    
    // Toca um som divertido (opcional)
    playKonamiSound();
  }

  function deactivateKonamiMode() {
    isKonamiActive = false;
    document.body.classList.remove('konami-mode');
    document.removeEventListener('keydown', escapeListener);
  }

  function escapeListener(e) {
    if (e.key === 'Escape' && isKonamiActive) {
      deactivateKonamiMode();
    }
  }

  function playKonamiSound() {
    // Cria um contexto de áudio e toca uma sequência de notas
    try {
      const audioContext = new (window.AudioContext || window.webkitAudioContext)();
      const notes = [523.25, 659.25, 783.99]; // Dó, Mi, Sol
      
      notes.forEach((freq, i) => {
        const oscillator = audioContext.createOscillator();
        const gainNode = audioContext.createGain();
        
        oscillator.connect(gainNode);
        gainNode.connect(audioContext.destination);
        
        oscillator.frequency.value = freq;
        oscillator.type = 'sine';
        
        const startTime = audioContext.currentTime + (i * 0.15);
        gainNode.gain.setValueAtTime(0.3, startTime);
        gainNode.gain.exponentialRampToValueAtTime(0.01, startTime + 0.3);
        
        oscillator.start(startTime);
        oscillator.stop(startTime + 0.3);
      });
    } catch (e) {
      console.log('🎮 Konami Code ativado (áudio não disponível)');
    }
  }

  // Console message para desenvolvedores curiosos
  console.log('%c🎮 Psiu! Tente o Konami Code...', 'color: #667eea; font-size: 16px; font-weight: bold;');
  console.log('%c↑ ↑ ↓ ↓ ← → ← → B A', 'color: #764ba2; font-size: 14px;');
})();